# ComfyUI中的使用流程

## 🎯 系统提示词设置的两种方式

### 方式1: 直接在节点中设置

```
ComfyUI界面操作流程：

1. 添加节点
   ┌─────────────────────────────────────┐
   │ 右键 → Add Node → Kontext/提示词工具 │
   │ → Kontext提示词小秘                  │
   └─────────────────────────────────────┘

2. 配置参数
   ┌─────────────────────────────────────┐
   │ 节点参数面板                         │
   ├─────────────────────────────────────┤
   │ API Base URL: https://api.openai... │
   │ API Key: sk-xxxxxxxxxxxxx           │
   │ Model: gpt-3.5-turbo               │
   │ ┌─────────────────────────────────┐ │
   │ │ System Prompt:                  │ │ ← 在这里输入系统提示词！
   │ │ 你是一个专业的文案写手，擅长...   │ │
   │ │ 创作吸引人的营销内容。请遵循...   │ │
   │ │ [可以输入多行文本]               │ │
   │ └─────────────────────────────────┘ │
   │ ┌─────────────────────────────────┐ │
   │ │ User Input:                     │ │
   │ │ 请为智能手表写一段宣传文案       │ │
   │ └─────────────────────────────────┘ │
   │ Temperature: 0.7                   │
   │ Max Tokens: 1000                   │
   └─────────────────────────────────────┘

3. 执行工作流
   点击 "Queue Prompt" 按钮执行
```

### 方式2: 使用模板节点（推荐）

```
工作流连接示意图：

┌─────────────────────┐    ┌─────────────────────┐
│  Kontext提示词模板   │    │  Kontext提示词小秘   │
├─────────────────────┤    ├─────────────────────┤
│ 模板类型: 创意写作   │    │ API Base URL: ...   │
│ 变量: {             │    │ API Key: ...        │
│   "topic": "AI",    │───▶│ System Prompt: [连接]│
│   "style": "科普"   │    │ User Input: ...     │
│ }                   │    │ Temperature: 0.7    │
└─────────────────────┘    └─────────────────────┘
         │                           │
         ▼                           ▼
   生成结构化的                   调用API生成
   系统提示词                     最终内容
```

## 📱 实际操作步骤

### 步骤1: 添加模板节点

1. 在ComfyUI中右键点击空白区域
2. 选择 `Add Node` → `Kontext/提示词工具` → `Kontext提示词模板`
3. 节点出现在画布上

### 步骤2: 配置模板

在模板节点中设置：

```
┌─────────────────────────────────────┐
│ Kontext提示词模板                    │
├─────────────────────────────────────┤
│ Template Type: [下拉选择]            │
│ ├── 创意写作                        │
│ ├── 代码生成                        │
│ ├── 文本总结                        │
│ ├── 翻译助手                        │
│ ├── 问答助手                        │
│ └── 自定义                          │
│                                     │
│ Variables: [JSON格式]               │
│ {                                   │
│   "topic": "人工智能应用",           │
│   "style": "技术博客",              │
│   "length": "800字",               │
│   "audience": "开发者"             │
│ }                                   │
│                                     │
│ Custom Template: [仅自定义时使用]    │
└─────────────────────────────────────┘
```

### 步骤3: 添加主节点

1. 添加 `Kontext提示词小秘` 节点
2. 配置API参数：

```
┌─────────────────────────────────────┐
│ Kontext提示词小秘                    │
├─────────────────────────────────────┤
│ API Base URL: https://api.openai... │
│ API Key: sk-xxxxxxxxxxxxx           │
│ Model: gpt-3.5-turbo               │
│ System Prompt: [等待连接]            │ ← 不需要手动输入
│ User Input: 请详细介绍机器学习的应用  │
│ Temperature: 0.7                   │
│ Max Tokens: 1000                   │
│ Timeout: 30                        │
│ Retry Count: 3                     │
└─────────────────────────────────────┘
```

### 步骤4: 连接节点

1. 点击模板节点的 `prompt_template` 输出点
2. 拖拽到主节点的 `system_prompt` 输入点
3. 连接线出现，表示连接成功

```
连接示意：
模板节点 [prompt_template] ────────▶ [system_prompt] 主节点
```

### 步骤5: 执行工作流

1. 点击 `Queue Prompt` 按钮
2. 查看执行结果：

```
输出结果：
┌─────────────────────────────────────┐
│ generated_text: [AI生成的内容]       │
│ full_response: [完整API响应JSON]     │
│ status_info: [执行状态信息]          │
└─────────────────────────────────────┘
```

## 🔧 高级工作流示例

### 多步骤内容生成

```
[用户输入] → [模板节点1] → [主节点1] → [模板节点2] → [主节点2] → [最终输出]
    │            │           │            │           │
    │            ▼           ▼            ▼           ▼
  原始需求    生成大纲    创建大纲    细化内容    生成文章
```

### 多语言翻译工作流

```
[原文] → [翻译模板] → [翻译节点] → [校对模板] → [校对节点] → [最终译文]
```

### 代码生成和注释工作流

```
[需求描述] → [代码模板] → [代码生成] → [注释模板] → [注释生成] → [完整代码]
```

## 💡 使用技巧

### 1. 模板变量的灵活使用

```json
// 基础变量
{
  "role": "专业角色",
  "task": "具体任务",
  "style": "输出风格"
}

// 高级变量
{
  "context": "项目背景信息",
  "constraints": "限制条件",
  "examples": "参考示例",
  "format": "输出格式要求"
}
```

### 2. 系统提示词的层次结构

```
第一层：角色定义
├── 专业背景
├── 经验水平
└── 专长领域

第二层：任务描述
├── 主要目标
├── 具体要求
└── 质量标准

第三层：输出规范
├── 格式要求
├── 长度限制
└── 风格指导
```

### 3. 调试和优化

1. **查看中间结果**：检查模板节点的输出
2. **逐步测试**：先测试模板，再测试完整流程
3. **参数调优**：根据结果调整temperature和max_tokens
4. **错误处理**：查看status_info了解执行状态

## 🚨 注意事项

### 1. API密钥安全
- 不要在工作流文件中保存API密钥
- 使用环境变量或配置文件
- 定期更换API密钥

### 2. 成本控制
- 合理设置max_tokens
- 选择适合的模型
- 监控API使用量

### 3. 网络连接
- 确保网络畅通
- 设置合适的超时时间
- 启用重试机制

---

通过这种方式，你可以在ComfyUI中灵活地设置和使用系统提示词，创建强大的AI内容生成工作流！