# 系统提示词设置示例

本文档展示如何在ComfyUI中设置和使用系统提示词。

## 🎯 方法1: 直接在节点中输入

### 基础示例
在"Kontext提示词小秘"节点的 `system_prompt` 输入框中直接输入：

```
你是一个专业的文案写手，擅长创作吸引人的营销内容。请遵循以下要求：
1. 语言简洁有力
2. 突出产品优势
3. 包含行动号召
4. 字数控制在指定范围内
```

### 角色扮演示例
```
你是一位资深的Python开发工程师，有10年以上的编程经验。你的任务是：
1. 为代码添加详细的注释
2. 解释代码的工作原理
3. 提供优化建议
4. 使用专业但易懂的语言
```

### 创意写作示例
```
你是一位获奖的科幻小说作家，擅长创作引人入胜的故事。请根据用户提供的元素创作内容，要求：
1. 情节紧凑有趣
2. 人物形象鲜明
3. 科幻元素合理
4. 语言生动形象
```

## 🛠️ 方法2: 使用模板节点（推荐）

### 步骤1: 添加模板节点
1. 在ComfyUI中添加"Kontext提示词模板"节点
2. 选择模板类型或使用自定义模板

### 步骤2: 配置模板变量
在模板节点的 `variables` 输入框中输入JSON格式的变量：

```json
{
  "role": "专业的技术文档写手",
  "expertise": "人工智能和机器学习",
  "style": "简洁明了，通俗易懂",
  "audience": "技术初学者",
  "format": "结构化文档",
  "length": "800字以内"
}
```

### 步骤3: 连接节点
将模板节点的 `prompt_template` 输出连接到主节点的 `system_prompt` 输入。

## 📝 实际工作流示例

### 示例1: 产品文案生成工作流

```
节点1: Kontext提示词模板
├── 模板类型: 创意写作
├── 变量: {
│     "topic": "智能手表",
│     "style": "营销文案",
│     "length": "200字",
│     "tone": "年轻活力",
│     "target": "年轻职场人士"
│   }
└── 输出: 生成的系统提示词

节点2: Kontext提示词小秘
├── system_prompt: [来自节点1]
├── user_input: "突出健康监测和智能提醒功能"
├── model: gpt-3.5-turbo
└── 输出: 营销文案
```

### 示例2: 代码注释工作流

```
节点1: 自定义模板
├── 自定义模板: "你是一位{language}专家，专门负责{task}。
│                请遵循{style}标准，为{audience}提供{type}。"
├── 变量: {
│     "language": "Python",
│     "task": "代码注释和文档编写",
│     "style": "Google Python Style Guide",
│     "audience": "团队开发者",
│     "type": "详细的代码注释"
│   }
└── 输出: 专业的系统提示词

节点2: Kontext提示词小秘
├── system_prompt: [来自节点1]
├── user_input: [粘贴需要注释的代码]
└── 输出: 带注释的代码
```

## 🎨 高级技巧

### 1. 多层次提示词结构

```
系统提示词结构：
┌─────────────────────────────────────┐
│ 角色定义: 你是一个专业的...           │
│ ├── 专业背景                        │
│ ├── 工作经验                        │
│ └── 专长领域                        │
│                                     │
│ 任务要求: 你的任务是...              │
│ ├── 主要目标                        │
│ ├── 具体要求                        │
│ └── 质量标准                        │
│                                     │
│ 输出格式: 请按照以下格式...           │
│ ├── 结构要求                        │
│ ├── 长度限制                        │
│ └── 风格要求                        │
└─────────────────────────────────────┘
```

### 2. 动态提示词生成

使用模板变量创建动态的系统提示词：

```json
{
  "base_role": "专业的内容创作者",
  "specialization": "{{从用户输入中提取}}",
  "context": "{{当前项目背景}}",
  "constraints": "{{具体限制条件}}",
  "output_format": "{{期望的输出格式}}"
}
```

### 3. 条件性提示词

```
你是一个智能助手。根据用户输入的内容类型，请采用相应的专业角色：

如果是代码相关：作为资深程序员
如果是写作相关：作为专业编辑
如果是设计相关：作为创意总监
如果是商业相关：作为商业顾问

请始终保持专业、准确、有帮助的态度。
```

## 🔧 调试和优化

### 1. 查看生成的系统提示词
在模板节点的输出中可以看到最终生成的系统提示词，用于调试。

### 2. 测试不同的提示词
通过修改模板变量快速测试不同的提示词效果。

### 3. 提示词版本管理
保存不同版本的模板配置，便于比较效果。

## 💡 最佳实践

### 1. 明确角色定义
```
好的角色定义:
"你是一位有15年经验的高级前端开发工程师，专精React和TypeScript开发。"

避免的角色定义:
"你是一个程序员。"
```

### 2. 具体的任务描述
```
好的任务描述:
"请为这个React组件添加详细的JSDoc注释，包括参数类型、返回值、使用示例和注意事项。"

避免的任务描述:
"给代码加注释。"
```

### 3. 清晰的输出要求
```
好的输出要求:
"请按照以下格式输出：
1. 功能概述（50字以内）
2. 详细说明（200-300字）
3. 使用示例（包含代码）
4. 注意事项（列表形式）"

避免的输出要求:
"详细说明一下。"
```

## 🚨 常见问题

### Q: 系统提示词太长会影响性能吗？
A: 会消耗更多tokens，建议控制在合理范围内（通常500-1000字符）。

### Q: 可以在代码中设置默认的系统提示词吗？
A: 可以，在nodes.py中修改默认值，但不推荐，因为会降低灵活性。

### Q: 如何保存常用的系统提示词？
A: 可以创建多个模板节点预设，或者使用ComfyUI的工作流保存功能。

### Q: 系统提示词和用户输入有什么区别？
A: 系统提示词定义AI的角色和行为规则，用户输入是具体的任务内容。

---

通过合理设置系统提示词，你可以让AI生成更符合需求的高质量内容！