# DeepSeek API 配置示例

## 🚀 DeepSeek R1 模型配置

### 基本配置信息
```
API Base URL: https://api.ds.lobeapi.com/v1
API Key: sk-YdPWWj1gQGwgqs95uKtu0AnkWj2OyNp37zhDRf0gyFG2wwVI
Model: deepseek-r1
```

### 在ComfyUI中的配置步骤

#### 步骤1: 添加Kontext提示词小秘节点
1. 在ComfyUI中右键点击空白区域
2. 选择 `Add Node` → `Kontext/提示词工具` → `Kontext提示词小秘`

#### 步骤2: 配置节点参数
在节点中填入以下参数：

```
┌─────────────────────────────────────────────────────────┐
│ Kontext提示词小秘 - DeepSeek R1 配置                     │
├─────────────────────────────────────────────────────────┤
│ API Base URL: https://api.ds.lobeapi.com/v1            │
│ API Key: sk-YdPWWj1gQGwgqs95uKtu0AnkWj2OyNp37zhDRf0... │
│ Model: deepseek-r1                                      │
│ System Prompt: 你是DeepSeek开发的AI助手，擅长逻辑推理   │
│ User Input: 请介绍一下你自己                            │
│ Temperature: 0.7                                        │
│ Max Tokens: 1000                                        │
│ Timeout: 30                                             │
│ Retry Count: 3                                          │
└─────────────────────────────────────────────────────────┘
```

## 🎯 DeepSeek R1 模型特点

### 模型优势
- **强大的推理能力**: DeepSeek R1 在逻辑推理方面表现出色
- **中文支持**: 对中文理解和生成效果很好
- **代码能力**: 在编程任务上有不错的表现
- **数学推理**: 擅长数学问题解决

### 推荐参数设置

#### 创意写作任务
```
Temperature: 0.8-1.0
Max Tokens: 800-1500
System Prompt: 你是一位富有创意的作家，擅长创作引人入胜的故事...
```

#### 逻辑推理任务
```
Temperature: 0.1-0.3
Max Tokens: 500-1000
System Prompt: 你是一位逻辑思维专家，擅长分析和推理...
```

#### 代码生成任务
```
Temperature: 0.2-0.5
Max Tokens: 1000-2000
System Prompt: 你是一位资深的程序员，擅长编写高质量的代码...
```

#### 数学解题任务
```
Temperature: 0.1-0.2
Max Tokens: 800-1200
System Prompt: 你是一位数学专家，擅长解决各种数学问题...
```

## 📝 使用示例

### 示例1: 逻辑推理任务

**模板节点配置:**
```json
{
  "role": "逻辑推理专家",
  "task": "分析问题并给出推理过程",
  "style": "步骤清晰，逻辑严密",
  "format": "1.问题分析 2.推理过程 3.结论"
}
```

**用户输入:**
```
有三个盒子，每个盒子里都有球。红盒子里的球数是蓝盒子的2倍，绿盒子里的球数是红盒子的一半。如果三个盒子总共有21个球，请问每个盒子里有多少个球？
```

### 示例2: 创意写作任务

**系统提示词:**
```
你是一位获奖的科幻小说作家，擅长创作富有想象力的故事。请根据用户提供的元素创作一个短故事，要求：
1. 情节紧凑有趣
2. 人物形象鲜明
3. 科幻元素合理
4. 字数控制在500字左右
```

**用户输入:**
```
关键词：时间旅行、古代书院、现代程序员
```

### 示例3: 代码生成任务

**系统提示词:**
```
你是一位Python专家，擅长编写清晰、高效的代码。请根据需求编写代码，并包含：
1. 详细的注释
2. 错误处理
3. 使用示例
4. 性能考虑
```

**用户输入:**
```
请编写一个Python函数，实现二分查找算法，要求支持自定义比较函数。
```

## 🔧 故障排除

### 常见问题及解决方案

#### 1. 连接超时
```
错误信息: "请求超时"
解决方案: 
- 增加timeout参数到60秒
- 检查网络连接
- 确认API服务状态
```

#### 2. API密钥错误
```
错误信息: "401 Unauthorized"
解决方案:
- 检查API Key是否正确复制
- 确认API Key是否有效
- 检查API Key是否有足够的配额
```

#### 3. 模型不存在
```
错误信息: "模型不存在"
解决方案:
- 确认模型名称为 "deepseek-r1"
- 检查API服务是否支持该模型
- 尝试其他可用模型
```

#### 4. 响应格式错误
```
错误信息: "响应解析错误"
解决方案:
- 检查API Base URL是否正确
- 确认API服务兼容OpenAI格式
- 查看完整响应内容
```

## 🎨 高级用法

### 1. 多轮对话模拟
通过在系统提示词中设置对话历史，可以模拟多轮对话效果。

### 2. 角色扮演
DeepSeek R1在角色扮演方面表现不错，可以设置具体的角色身份。

### 3. 专业领域应用
针对特定领域（如法律、医学、教育）设置专业的系统提示词。

### 4. 创意协作
与其他AI工具结合，形成创意内容生产流水线。

## 💡 最佳实践

### 1. 提示词优化
- 明确指定任务类型
- 提供具体的输出要求
- 包含相关的背景信息

### 2. 参数调优
- 根据任务类型调整temperature
- 合理设置max_tokens避免截断
- 使用重试机制提高稳定性

### 3. 成本控制
- 监控API使用量
- 优化提示词长度
- 选择合适的模型

---

**开始使用DeepSeek R1模型，体验强大的AI推理能力！** 🚀