# 如何在ComfyUI中查看Kontext提示词小秘生成的内容

## 🎯 问题分析

你的工作流中，Kontext提示词小秘节点(195)的输出直接连接到了CLIPTextEncode节点(6)，所以你看不到中间生成的文本内容。

## 🔧 解决方案

### 方法1: 添加文本显示节点

#### 步骤1: 添加ShowText节点
1. 在ComfyUI中右键点击空白区域
2. 选择 `Add Node` → `utils` → `ShowText` (或搜索"ShowText")
3. 将节点放置在合适位置

#### 步骤2: 连接节点
```
原始连接:
KontextPromptAssistant(195) → CLIPTextEncode(6)

修改后的连接:
KontextPromptAssistant(195) → ShowText → CLIPTextEncode(6)
                           ↘ (同时连接到ShowText查看内容)
```

#### 步骤3: 连接方式
1. 从KontextPromptAssistant节点的 `generated_text` 输出
2. 连接到ShowText节点的 `text` 输入
3. 从ShowText节点的 `STRING` 输出
4. 连接到CLIPTextEncode节点的 `text` 输入

### 方法2: 添加文本预览节点

#### 使用PreviewTextNode
```
KontextPromptAssistant(195) 
    ↓ generated_text
PreviewTextNode (显示生成的文本)
    ↓ text (传递给下一个节点)
CLIPTextEncode(6)
```

### 方法3: 添加SaveText节点

#### 保存生成的文本到文件
```
KontextPromptAssistant(195)
    ↓ generated_text  
SaveText (保存到文件)
    ↓ text (传递给下一个节点)
CLIPTextEncode(6)
```

## 📋 具体操作步骤

### 在你的工作流中添加调试节点:

1. **断开现有连接**:
   - 点击KontextPromptAssistant(195)到CLIPTextEncode(6)之间的连接线
   - 按Delete键删除连接

2. **添加ShowText节点**:
   - 右键 → Add Node → utils → ShowText
   - 放置在两个节点之间

3. **重新连接**:
   ```
   KontextPromptAssistant(195) [generated_text] → ShowText [text]
   ShowText [STRING] → CLIPTextEncode(6) [text]
   ```

4. **运行工作流**:
   - 点击"Queue Prompt"
   - 在ShowText节点中查看生成的内容

## 🎯 Kontext提示词小秘的输出说明

### 节点输出端口:
```
KontextPromptAssistant节点有3个输出:
├── generated_text (STRING)  ← 这是主要的生成内容
├── full_response (STRING)   ← 完整的API响应JSON
└── status_info (STRING)     ← 执行状态信息
```

### 你应该连接的输出:
- **generated_text**: 这是AI生成的主要文本内容，应该连接到CLIPTextEncode
- **full_response**: 包含完整API响应，用于调试
- **status_info**: 显示执行状态，用于错误排查

## 🔍 调试工作流示例

### 完整的调试工作流:
```
KontextPromptAssistant(195)
├── generated_text → ShowText(新增) → CLIPTextEncode(6)
├── full_response → ShowText(调试用)
└── status_info → ShowText(状态显示)
```

### JSON配置示例:
```json
{
  "id": "new_showtext_node",
  "type": "ShowText", 
  "pos": [-400, 400],
  "size": [400, 200],
  "inputs": [
    {
      "name": "text",
      "type": "STRING", 
      "link": "from_kontext_generated_text"
    }
  ],
  "outputs": [
    {
      "name": "STRING",
      "type": "STRING",
      "links": ["to_clip_text_encode"]
    }
  ]
}
```

## 🚨 常见问题排查

### 问题1: 看不到任何输出
**可能原因:**
- API调用失败
- 网络连接问题
- API密钥无效

**解决方法:**
1. 检查status_info输出
2. 查看ComfyUI控制台日志
3. 验证API配置

### 问题2: 输出为空
**可能原因:**
- 系统提示词或用户输入为空
- API返回空响应
- 模型无法理解指令

**解决方法:**
1. 检查输入参数
2. 查看full_response输出
3. 调整提示词内容

### 问题3: 输出格式异常
**可能原因:**
- API响应格式不标准
- 模型输出包含特殊字符

**解决方法:**
1. 查看full_response
2. 调整temperature参数
3. 优化系统提示词

## 💡 最佳实践

### 1. 开发阶段
```
始终添加调试节点:
KontextPromptAssistant → ShowText → 目标节点
```

### 2. 生产阶段
```
移除调试节点，直接连接:
KontextPromptAssistant → 目标节点
```

### 3. 错误处理
```
添加状态监控:
KontextPromptAssistant [status_info] → ShowText (错误显示)
```

## 🎨 实际操作演示

### 你的当前任务调试:

1. **输入**: "将字母'talk'改为'ai'"
2. **期望输出**: "将字母'ai'改为'ai'" 或类似的修改结果
3. **调试步骤**:
   ```
   1. 添加ShowText节点查看generated_text
   2. 检查是否正确理解了修改指令
   3. 验证输出是否符合预期
   4. 如果不符合，调整系统提示词
   ```

### 优化后的系统提示词建议:
```
你是文本编辑专家。请根据用户的修改指令，对文本进行精确修改。

用户指令格式: "将字母'X'改为'Y'"
你的任务: 找到文本中的字母X，替换为字母Y

请直接输出修改后的结果，不要添加解释。
```

---

通过添加ShowText节点，你就能清楚地看到Kontext提示词小秘生成了什么内容！