# API配置示例

本文档提供了各种AI服务的API配置示例，帮助你快速配置Kontext提示词小秘节点。

## OpenAI官方API

### GPT-3.5 Turbo
```
API Base URL: https://api.openai.com/v1
Model: gpt-3.5-turbo
API Key: sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
Temperature: 0.7
Max Tokens: 1000
```

### GPT-4
```
API Base URL: https://api.openai.com/v1
Model: gpt-4
API Key: sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
Temperature: 0.7
Max Tokens: 1000
```

## Azure OpenAI

### 配置示例
```
API Base URL: https://your-resource.openai.azure.com/openai/deployments/your-deployment-name
Model: gpt-35-turbo (注意：Azure中的模型名称格式)
API Key: your-azure-api-key
Temperature: 0.7
Max Tokens: 1000
```

### URL格式说明
- `your-resource`: 你的Azure OpenAI资源名称
- `your-deployment-name`: 你创建的部署名称

## 本地部署 - Ollama

### 基础配置
```
API Base URL: http://localhost:11434/v1
Model: llama2
API Key: ollama (任意值，Ollama不验证)
Temperature: 0.7
Max Tokens: 1000
```

### 常用模型
- `llama2`: Meta的Llama 2模型
- `codellama`: 专门用于代码生成的模型
- `mistral`: Mistral AI的开源模型
- `vicuna`: 基于Llama的对话模型

## 本地部署 - Text Generation WebUI

### 配置示例
```
API Base URL: http://localhost:5000/v1
Model: your-loaded-model-name
API Key: any-value
Temperature: 0.7
Max Tokens: 1000
```

## Claude API (Anthropic)

### 配置示例
```
API Base URL: https://api.anthropic.com/v1
Model: claude-3-sonnet-20240229
API Key: sk-ant-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
Temperature: 0.7
Max Tokens: 1000
```

### 可用模型
- `claude-3-opus-20240229`: 最强大的模型
- `claude-3-sonnet-20240229`: 平衡性能和成本
- `claude-3-haiku-20240307`: 快速响应模型

## 国内API服务

### 智谱AI (GLM)
```
API Base URL: https://open.bigmodel.cn/api/paas/v4
Model: glm-4
API Key: your-zhipu-api-key
Temperature: 0.7
Max Tokens: 1000
```

### 百度文心一言
```
API Base URL: https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat
Model: ernie-bot-turbo
API Key: your-baidu-api-key
Temperature: 0.7
Max Tokens: 1000
```

### 阿里通义千问
```
API Base URL: https://dashscope.aliyuncs.com/api/v1
Model: qwen-turbo
API Key: your-dashscope-api-key
Temperature: 0.7
Max Tokens: 1000
```

## 自定义API服务

### 通用OpenAI兼容格式
```
API Base URL: https://your-custom-api.com/v1
Model: your-model-name
API Key: your-api-key
Temperature: 0.7
Max Tokens: 1000
```

## 参数说明

### Temperature (温度)
- `0.0`: 最确定性的输出，适合需要一致性的任务
- `0.3-0.7`: 平衡创造性和一致性，适合大多数任务
- `0.8-1.0`: 更有创造性，适合创意写作
- `1.0+`: 非常随机，适合头脑风暴

### Max Tokens (最大令牌数)
- `100-500`: 短回答，摘要
- `500-1000`: 中等长度内容
- `1000-2000`: 长文章，详细解释
- `2000+`: 非常长的内容（注意API限制）

### Timeout (超时时间)
- `10-30秒`: 快速响应的本地模型
- `30-60秒`: 云端API服务
- `60秒+`: 复杂任务或慢速网络

### Retry Count (重试次数)
- `1-3次`: 稳定的API服务
- `3-5次`: 不太稳定的服务
- `5次+`: 网络条件较差的环境

## 故障排除

### 常见错误及解决方案

1. **401 Unauthorized**
   - 检查API密钥是否正确
   - 确认API密钥有效期

2. **404 Not Found**
   - 检查API Base URL是否正确
   - 确认模型名称是否存在

3. **429 Too Many Requests**
   - 降低请求频率
   - 检查API配额限制

4. **Connection Error**
   - 检查网络连接
   - 确认防火墙设置
   - 验证URL可访问性

5. **Timeout Error**
   - 增加超时时间
   - 检查网络延迟
   - 减少max_tokens参数

## 最佳实践

1. **API密钥安全**
   - 不要在工作流文件中硬编码API密钥
   - 使用环境变量或配置文件
   - 定期轮换API密钥

2. **成本控制**
   - 设置合理的max_tokens限制
   - 监控API使用量
   - 选择适合任务的模型

3. **性能优化**
   - 根据任务调整temperature
   - 使用合适的超时时间
   - 启用重试机制

4. **错误处理**
   - 检查status_info输出
   - 实现降级策略
   - 记录错误日志