"""
Kontext提示词小秘 - 配置文件
"""

# 默认配置
DEFAULT_CONFIG = {
    "api_base_url": "https://api.openai.com/v1",
    "model": "gpt-3.5-turbo",
    "temperature": 0.7,
    "max_tokens": 1000,
    "timeout": 30,
    "retry_count": 3,
}

# 预设的API服务配置
API_PRESETS = {
    "OpenAI": {
        "api_base_url": "https://api.openai.com/v1",
        "models": ["gpt-3.5-turbo", "gpt-4", "gpt-4-turbo-preview"]
    },
    "Ollama本地": {
        "api_base_url": "http://localhost:11434/v1",
        "models": ["llama2", "codellama", "mistral"]
    },
    "Azure OpenAI": {
        "api_base_url": "https://your-resource.openai.azure.com/openai/deployments/your-deployment",
        "models": ["gpt-35-turbo", "gpt-4"]
    }
}

# 提示词模板变量说明
TEMPLATE_VARIABLES = {
    "创意写作": {
        "required": ["topic", "style", "length"],
        "optional": ["tone", "audience", "format"],
        "example": {
            "topic": "人工智能的未来",
            "style": "科普文章",
            "length": "800字",
            "tone": "客观中性",
            "audience": "普通读者"
        }
    },
    "代码生成": {
        "required": ["language", "requirement", "style"],
        "optional": ["framework", "complexity", "comments"],
        "example": {
            "language": "Python",
            "requirement": "实现一个简单的计算器",
            "style": "面向对象",
            "framework": "无",
            "complexity": "初级"
        }
    },
    "文本总结": {
        "required": ["summary_type", "length", "focus"],
        "optional": ["format", "audience"],
        "example": {
            "summary_type": "要点总结",
            "length": "200字以内",
            "focus": "核心观点",
            "format": "列表形式"
        }
    },
    "翻译助手": {
        "required": ["source_lang", "target_lang", "style"],
        "optional": ["domain", "formality"],
        "example": {
            "source_lang": "中文",
            "target_lang": "英文",
            "style": "自然流畅",
            "domain": "技术文档",
            "formality": "正式"
        }
    },
    "问答助手": {
        "required": ["domain", "depth", "style"],
        "optional": ["examples", "format"],
        "example": {
            "domain": "计算机科学",
            "depth": "详细解释",
            "style": "教学式",
            "examples": "包含实例",
            "format": "结构化"
        }
    }
}