# Kontext提示词小秘 - ComfyUI节点插件

一个强大的ComfyUI节点插件，支持连接OpenAI兼容的API，让你在ComfyUI工作流中轻松使用AI生成内容。

## 功能特性

- 🤖 **OpenAI兼容API支持**: 支持OpenAI、Claude、本地部署的模型等
- 🎯 **灵活的提示词系统**: 支持系统提示词和用户输入的组合
- 🔄 **智能重试机制**: 自动重试失败的API调用，提高稳定性
- 📝 **提示词模板**: 内置多种常用提示词模板
- ⚙️ **丰富的参数控制**: 温度、最大token数、超时时间等可调节
- 🛡️ **错误处理**: 完善的错误处理和状态反馈
- 🔒 **安全保护**: API密钥遮蔽显示、环境变量支持、工作流清理工具

## 安装方法

1. 将此插件文件夹复制到ComfyUI的 `custom_nodes` 目录下
2. 重启ComfyUI
3. 在节点菜单中找到 "Kontext/提示词工具" 分类

## 节点说明

### Kontext提示词小秘

主要的AI文本生成节点，支持以下功能：

### Kontext提示词小秘(安全版)

增强安全性的AI文本生成节点，新增功能：
- 🔒 **密码模式**: API密钥自动星号遮蔽
- 🌍 **环境变量**: 支持从环境变量读取API密钥
- 🛡️ **敏感信息过滤**: 自动过滤响应中的敏感信息
- ✅ **密钥验证**: 内置API密钥有效性验证

### Kontext密钥管理器

专门的API密钥管理工具：
- 🔑 **密钥验证**: 测试API密钥有效性
- 🌍 **环境变量管理**: 设置和管理环境变量
- 🧹 **缓存清理**: 清除敏感信息缓存

#### 输入参数

**必需参数:**
- `api_base_url`: API基础URL (默认: https://api.openai.com/v1)
- `api_key`: API密钥
- `model`: 模型名称 (如: gpt-3.5-turbo, gpt-4, claude-3-sonnet等)
- `system_prompt`: 系统提示词
- `user_input`: 用户输入内容
- `temperature`: 创造性控制 (0.0-2.0)
- `max_tokens`: 最大生成token数

**可选参数:**
- `timeout`: 请求超时时间 (秒)
- `retry_count`: 重试次数

#### 输出

- `generated_text`: 生成的文本内容
- `full_response`: 完整的API响应 (JSON格式)
- `status_info`: 状态信息和错误提示

### Kontext提示词模板

提供预设的提示词模板，支持变量替换：

#### 内置模板

- **创意写作**: 用于创意内容生成
- **代码生成**: 用于编程代码生成
- **文本总结**: 用于文本摘要
- **翻译助手**: 用于多语言翻译
- **问答助手**: 用于问答场景
- **自定义**: 使用自定义模板

#### 变量系统

使用JSON格式定义变量，例如：
```json
{
  "topic": "人工智能",
  "style": "正式",
  "length": "500字"
}
```

## 使用示例

### 基础使用

1. 添加"Kontext提示词小秘"节点
2. 配置API信息（URL、密钥、模型）
3. 设置系统提示词和用户输入
4. 连接到其他节点使用生成的文本

### 配合模板使用

1. 添加"Kontext提示词模板"节点
2. 选择合适的模板类型
3. 配置变量参数
4. 将模板输出连接到主节点的系统提示词输入

### 工作流示例

```
[用户输入] → [提示词模板] → [Kontext提示词小秘] → [文本处理节点]
```

## 支持的API服务

- **OpenAI**: 官方API服务
- **Azure OpenAI**: 微软Azure平台
- **Claude**: Anthropic的Claude模型
- **本地部署**: 支持OpenAI格式的本地模型
- **其他兼容服务**: 任何支持OpenAI Chat Completions格式的API

## 配置示例

### OpenAI官方API
```
API Base URL: https://api.openai.com/v1
Model: gpt-3.5-turbo
API Key: sk-...
```

### 本地Ollama
```
API Base URL: http://localhost:11434/v1
Model: llama2
API Key: ollama (或任意值)
```

### Azure OpenAI
```
API Base URL: https://your-resource.openai.azure.com/openai/deployments/your-deployment
Model: gpt-35-turbo
API Key: your-azure-key
```

## 错误处理

插件包含完善的错误处理机制：

- **网络错误**: 自动重试连接
- **API错误**: 显示详细错误信息
- **参数错误**: 验证输入参数
- **超时处理**: 可配置的超时时间

## 🔒 安全使用

### API密钥保护
1. **使用安全版本节点**: 推荐使用"Kontext提示词小秘(安全版)"
2. **环境变量配置**: 将API密钥设置为环境变量
3. **工作流清理**: 分享前使用`workflow_cleaner.py`清理敏感信息
4. **定期轮换**: 定期更换API密钥

### 环境变量设置
```bash
# Windows
set OPENAI_API_KEY=your-api-key
set DEEPSEEK_API_KEY=your-deepseek-key

# Linux/Mac  
export OPENAI_API_KEY=your-api-key
export DEEPSEEK_API_KEY=your-deepseek-key
```

### 工作流清理
```bash
# 清理工作流中的敏感信息
python workflow_cleaner.py my_workflow.json

# 生成安全的分享版本
python workflow_cleaner.py my_workflow.json safe_workflow.json
```

详细安全指南请查看 [SECURITY_GUIDE.md](SECURITY_GUIDE.md)

## 注意事项

1. **API密钥安全**: 请妥善保管你的API密钥，使用环境变量或安全版本节点
2. **费用控制**: 注意API调用可能产生的费用
3. **速率限制**: 遵守API服务商的速率限制
4. **网络连接**: 确保ComfyUI能够访问API服务
5. **工作流分享**: 分享前请清理敏感信息

## 更新日志

### v1.0.0
- 初始版本发布
- 支持OpenAI兼容API
- 内置提示词模板系统
- 完善的错误处理和重试机制

## 技术支持

如果遇到问题或有功能建议，请通过以下方式联系：

- 创建GitHub Issue
- 在ComfyUI社区讨论

## 许可证

MIT License - 详见LICENSE文件

---

**Kontext提示词小秘** - 让AI生成更简单，让创作更高效！