# Kontext提示词小秘 - 快速开始指南

欢迎使用Kontext提示词小秘！这个指南将帮助你快速上手。

## 🚀 快速安装

### 方法1: 自动安装（推荐）
```bash
# 在ComfyUI/custom_nodes/目录下
git clone https://github.com/your-repo/kontext-prompt-assistant.git
cd kontext-prompt-assistant
python install.py
```

### 方法2: 手动安装
1. 下载插件文件到 `ComfyUI/custom_nodes/kontext-prompt-assistant/`
2. 安装依赖: `pip install requests`
3. 重启ComfyUI

## 🎯 5分钟上手

### 步骤1: 添加节点
1. 重启ComfyUI后，在节点菜单中找到 `Kontext/提示词工具`
2. 添加 `Kontext提示词小秘` 节点

### 步骤2: 配置API
```
API Base URL: https://api.openai.com/v1
API Key: 你的OpenAI API密钥
Model: gpt-3.5-turbo
```

### 步骤3: 设置提示词
```
系统提示词: 你是一个专业的文案写手，擅长创作吸引人的内容。
用户输入: 请为一款AI绘画软件写一段宣传文案。
```

### 步骤4: 运行工作流
点击执行，查看生成的文本内容！

## 🛠️ 常用配置

### OpenAI官方API
```
API Base URL: https://api.openai.com/v1
Model: gpt-3.5-turbo 或 gpt-4
API Key: sk-xxxxxxxxxxxxxxxx
```

### 本地Ollama
```
API Base URL: http://localhost:11434/v1
Model: llama2 或其他本地模型
API Key: 任意值（如"ollama"）
```

### Claude API
```
API Base URL: https://api.anthropic.com/v1
Model: claude-3-sonnet-20240229
API Key: sk-ant-xxxxxxxxxxxxxxxx
```

## 📝 使用模板

### 添加模板节点
1. 添加 `Kontext提示词模板` 节点
2. 选择模板类型（如"创意写作"）
3. 配置变量：
```json
{
  "topic": "人工智能",
  "style": "科普文章", 
  "length": "500字"
}
```

### 连接节点
将模板节点的输出连接到主节点的"系统提示词"输入。

## 🔧 参数调优

### Temperature（创造性）
- `0.0-0.3`: 准确、一致的输出
- `0.4-0.7`: 平衡创造性和准确性
- `0.8-1.0`: 更有创造性的输出

### Max Tokens（长度控制）
- `100-300`: 短回答
- `500-1000`: 中等长度
- `1000+`: 长文本

## 🚨 常见问题

### 1. "错误: API密钥不能为空"
- 检查API Key是否正确填写
- 确认API Key有效且有余额

### 2. "连接错误"
- 检查网络连接
- 确认API Base URL正确
- 检查防火墙设置

### 3. "模型不存在"
- 确认模型名称正确
- 检查API服务是否支持该模型

### 4. 响应很慢
- 增加超时时间
- 减少max_tokens
- 检查网络延迟

## 💡 使用技巧

### 1. 提示词优化
```
好的提示词:
"你是一位专业的技术文档写手。请用简洁明了的语言，为初学者解释什么是API。要求：1）使用通俗易懂的比喻 2）包含具体例子 3）字数控制在300字以内。"

避免的提示词:
"解释API"
```

### 2. 模板变量使用
```json
{
  "role": "专业的营销文案师",
  "product": "智能手表",
  "target_audience": "年轻职场人士",
  "tone": "活力、专业",
  "length": "200字",
  "call_to_action": "立即购买"
}
```

### 3. 工作流设计
```
[用户输入] → [模板节点] → [AI生成] → [文本处理] → [输出]
```

## 🎨 实用示例

### 示例1: 产品文案生成
```
模板类型: 创意写作
变量: {"topic": "智能音箱", "style": "营销文案", "length": "150字"}
用户输入: 突出产品的智能语音交互功能
```

### 示例2: 代码注释生成
```
模板类型: 代码生成
变量: {"language": "Python", "requirement": "为函数添加详细注释", "style": "Google风格"}
用户输入: [粘贴你的代码]
```

### 示例3: 文章摘要
```
模板类型: 文本总结
变量: {"summary_type": "要点总结", "length": "100字", "focus": "核心观点"}
用户输入: [粘贴要总结的文章]
```

## 📊 成本控制

### 1. 选择合适的模型
- GPT-3.5-turbo: 便宜，适合大多数任务
- GPT-4: 更强但更贵，适合复杂任务
- 本地模型: 免费但需要本地部署

### 2. 控制Token使用
- 设置合理的max_tokens限制
- 优化提示词长度
- 避免不必要的重复生成

### 3. 监控使用量
- 定期检查API使用统计
- 设置使用量警报
- 记录重要的生成结果

## 🔗 更多资源

- 📖 [完整文档](README.md)
- 🔧 [API配置示例](examples/api_config_examples.md)
- 🐛 [故障排除](README.md#故障排除)
- 💬 [社区讨论](https://github.com/your-repo/issues)

---

**开始你的AI创作之旅吧！** 🚀

如果遇到问题，请查看完整文档或提交Issue获取帮助。