<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>举报系统</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            padding-top: 20px;
            padding-bottom: 20px;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            background-attachment: fixed;
            position: relative;
        }
        
        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('https://cdn.pixabay.com/photo/2018/03/22/02/37/background-3249063_1280.png');
            background-size: cover;
            background-position: center;
            opacity: 0.1;
            z-index: -1;
        }
        
        .container {
            max-width: 800px;
            position: relative;
            z-index: 1;
        }
        
        .required:after {
            content: " *";
            color: #dc3545;
            font-weight: bold;
        }
        
        .card {
            border-radius: 10px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            border: none;
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(5px);
        }
        
        .card-body {
            padding: 30px;
        }
        
        h1 {
            color: #0d6efd;
            font-weight: 600;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .btn-primary {
            background-color: #0d6efd;
            border: none;
            padding: 10px 0;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #0b5ed7;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
        }
        
        .form-control, .form-select {
            padding: 10px 15px;
            border-radius: 8px;
        }
        
        .form-control:focus, .form-select:focus {
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        
        .admin-link {
            color: #6c757d;
            text-decoration: none;
            transition: color 0.3s;
            background-color: rgba(255, 255, 255, 0.7);
            padding: 5px 15px;
            border-radius: 20px;
        }
        
        .admin-link:hover {
            color: #0d6efd;
            background-color: rgba(255, 255, 255, 0.9);
        }
        
        footer {
            background-color: rgba(255, 255, 255, 0.7);
            padding: 10px;
            border-radius: 10px;
            margin-top: 30px !important;
        }
        
        .alert {
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 20px;
            position: relative;
        }
        
        .logo {
            max-height: 80px;
            max-width: 100%;
        }
        
        .logo-upload-container {
            display: none;
            margin-top: 10px;
            padding: 15px;
            background-color: rgba(255, 255, 255, 0.8);
            border-radius: 8px;
        }
        
        .admin-options {
            position: absolute;
            top: 0;
            right: 0;
            margin-bottom: 0;
        }
        
        .btn-change-logo {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        
        h1.site-title {
            font-size: 1.8rem;
            margin-bottom: 1.5rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="user-links">
            <?php
            session_start();
            if(isset($_SESSION['user_id'])) {
                echo '<span class="me-2">欢迎, ' . htmlspecialchars($_SESSION['username']) . '</span>';
                echo '<a href="user_dashboard.php" class="user-link me-2"><i class="bi bi-person-circle me-1"></i>用户平台</a>';
                echo '<a href="logout.php" class="user-link"><i class="bi bi-box-arrow-right me-1"></i>退出登录</a>';
            } else {
                echo '<a href="login.php" class="user-link"><i class="bi bi-person me-1"></i>登录</a>';
                echo '<a href="register.php" class="user-link"><i class="bi bi-person-plus me-1"></i>注册</a>';
            }
            ?>
        </div>
        
        <div class="logo-container">
            <?php if(file_exists('uploads/logo.png')): ?>
                <img src="uploads/logo.png" alt="网站Logo" class="logo">
            <?php else: ?>
                <h1 class="mb-4 text-center site-title">内容举报平台</h1>
            <?php endif; ?>
            
            <div class="admin-options">
                <button class="btn btn-sm btn-outline-secondary btn-change-logo" onclick="toggleLogoUpload()">
                    <i class="bi bi-image"></i> 更换Logo
                </button>
            </div>
            
            <div id="logoUploadForm" class="logo-upload-container">
                <form action="upload_logo.php" method="post" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="logo_file" class="form-label">选择Logo图片</label>
                        <input type="file" class="form-control" id="logo_file" name="logo_file" accept="image/*" required>
                        <div class="form-text">建议尺寸: 300x80px，格式: PNG (透明背景)</div>
                    </div>
                    <div class="d-flex justify-content-end">
                        <button type="button" class="btn btn-outline-secondary me-2" onclick="toggleLogoUpload()">取消</button>
                        <button type="submit" class="btn btn-primary">上传Logo</button>
                    </div>
                </form>
            </div>
        </div>
        
        <?php if(isset($_GET['error'])): ?>
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-triangle-fill me-2"></i>
            <?php echo htmlspecialchars($_GET['error']); ?>
        </div>
        <?php endif; ?>
        
        <?php if(isset($_GET['success']) && $_GET['success'] == 'logo'): ?>
        <div class="alert alert-success">
            <i class="bi bi-check-circle-fill me-2"></i>
            Logo上传成功！
        </div>
        <?php endif; ?>
        
        <div class="card mb-4">
            <div class="card-body">
                <form action="submit_report.php" method="post" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="reporter_name" class="form-label required">举报人姓名</label>
                        <input type="text" class="form-control" id="reporter_name" name="reporter_name" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="reporter_contact" class="form-label required">联系方式</label>
                        <input type="text" class="form-control" id="reporter_contact" name="reporter_contact" placeholder="电话号码或电子邮箱" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="report_type" class="form-label required">举报类型</label>
                        <select class="form-select" id="report_type" name="report_type" required>
                            <option value="">请选择举报类型</option>
                            <option value="垃圾信息">垃圾信息</option>
                            <option value="色情内容">色情内容</option>
                            <option value="暴力内容">暴力内容</option>
                            <option value="政治敏感">政治敏感</option>
                            <option value="侵权内容">侵权内容</option>
                            <option value="诈骗信息">诈骗信息</option>
                            <option value="其他">其他</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="report_content" class="form-label required">举报内容描述</label>
                        <textarea class="form-control" id="report_content" name="report_content" rows="5" placeholder="请详细描述您要举报的内容..." required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label for="reported_url" class="form-label">相关链接</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-link-45deg"></i></span>
                            <input type="url" class="form-control" id="reported_url" name="reported_url" placeholder="http://">
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <label for="evidence_file" class="form-label">证据上传</label>
                        <input type="file" class="form-control" id="evidence_file" name="evidence_file">
                        <div class="form-text"><i class="bi bi-info-circle me-1"></i>支持图片、文档等格式，大小不超过5MB</div>
                    </div>
                    
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="bi bi-send me-2"></i>提交举报
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="mt-4 text-center">
            <a href="admin/login.php" class="admin-link">
                <i class="bi bi-shield-lock me-1"></i>管理员登录
            </a>
        </div>
        
        <footer class="mt-5 text-center text-muted">
            <small>&copy; <?php echo date('Y'); ?> 举报系统 - 共建健康网络环境</small>
        </footer>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function toggleLogoUpload() {
            const logoUploadForm = document.getElementById('logoUploadForm');
            if (logoUploadForm.style.display === 'block') {
                logoUploadForm.style.display = 'none';
            } else {
                logoUploadForm.style.display = 'block';
            }
        }
    </script>
</body>
</html>