<?php
/**
 * 认证相关函数
 */

/**
 * 检查用户是否已登录
 * 
 * @return bool 是否已登录
 */
function isLoggedIn() {
    session_start();
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

/**
 * 验证用户登录
 * 
 * @param string $username 用户名
 * @param string $password 密码
 * @return bool 验证是否成功
 */
function validateLogin($username, $password) {
    // 从配置文件获取管理员账号信息
    $config_file = __DIR__ . '/../config/admin_config.php';
    if (file_exists($config_file)) {
        $admin_config = require $config_file;
        
        // 验证用户名和密码
        if (isset($admin_config['username']) && isset($admin_config['password'])) {
            if ($username === $admin_config['username'] && password_verify($password, $admin_config['password'])) {
                return true;
            }
        }
    }
    
    return false;
}

/**
 * 设置用户登录状态
 * 
 * @param string $username 用户名
 */
function setLoggedIn($username) {
    $_SESSION['admin_logged_in'] = true;
    $_SESSION['admin_username'] = $username;
    $_SESSION['login_time'] = time();
}

/**
 * 注销用户
 */
function logout() {
    session_start();
    $_SESSION = array();
    session_destroy();
}