<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '未授权访问']);
    exit;
}

// 获取POST数据
$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['email']) || empty($data['email'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '缺少邮箱地址']);
    exit;
}

$email = $data['email'];

// 验证邮箱格式
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '邮箱地址格式不正确']);
    exit;
}

// 引入通知辅助函数
require_once '../includes/notification_helper.php';

// 构建测试邮件内容
$subject = '【举报系统】邮件通知测试';
$message = '
<html>
<head>
    <title>邮件通知测试</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #f8f9fa; padding: 15px; border-bottom: 3px solid #0d6efd; }
        .content { padding: 20px 0; }
        .footer { font-size: 12px; color: #6c757d; border-top: 1px solid #dee2e6; padding-top: 15px; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>邮件通知测试</h2>
        </div>
        <div class="content">
            <p>这是一条测试邮件，用于验证举报系统的邮件通知功能是否正常工作。</p>
            <p>如果您收到此邮件，说明邮件通知功能配置正确。</p>
            <p>测试时间：' . date('Y-m-d H:i:s') . '</p>
            <p>测试用户：' . htmlspecialchars($_SESSION['admin_username']) . '</p>
        </div>
        <div class="footer">
            <p>此邮件由系统自动发送，请勿直接回复。</p>
        </div>
    </div>
</body>
</html>';

// 发送测试邮件
$result = send_email_notification($email, $subject, $message);

if ($result) {
    header('Content-Type: application/json');
    echo json_encode(['success' => true]);
} else {
    // 获取最后一个错误信息
    $error = error_get_last();
    $error_message = $error ? $error['message'] : '未知错误';
    
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '邮件发送失败: ' . $error_message]);
}