<?php
// 启动会话
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '未授权访问'
    ]);
    exit;
}

// 检查请求方法
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '无效的请求方法'
    ]);
    exit;
}

// 获取邮件设置
$smtp_server = $_POST['smtp_server'] ?? '';
$smtp_port = $_POST['smtp_port'] ?? '587';
$smtp_username = $_POST['smtp_username'] ?? '';
$smtp_password = $_POST['smtp_password'] ?? '';
$email_sender = $_POST['email_sender'] ?? '';
$email_recipients = $_POST['email_recipients'] ?? '';

// 验证必填字段
if (empty($smtp_server) || empty($smtp_username) || empty($email_recipients)) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '请填写SMTP服务器、用户名和收件人邮箱'
    ]);
    exit;
}

// 记录请求信息
error_log('测试邮件发送，SMTP服务器: ' . $smtp_server . ', 端口: ' . $smtp_port . ', 用户名: ' . $smtp_username . ', 发件人: ' . $email_sender . ', 收件人: ' . $email_recipients);

try {
    // 引入PHPMailer库
    require_once '../vendor/autoload.php';
    
    // 如果autoload.php不存在，返回错误
    if (!file_exists('../vendor/autoload.php')) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => '缺少PHPMailer库，请先运行 composer require phpmailer/phpmailer'
        ]);
        exit;
    }
    
    // 使用PHPMailer发送测试邮件
    $mail = new PHPMailer\PHPMailer\PHPMailer(true);
    
    // 服务器设置
    $mail->SMTPDebug = 0; // 调试级别，0为关闭
    $mail->isSMTP();
    $mail->Host = $smtp_server;
    $mail->SMTPAuth = true;
    $mail->Username = $smtp_username;
    $mail->Password = $smtp_password;
    $mail->SMTPSecure = ($smtp_port == '465') ? 'ssl' : 'tls';
    $mail->Port = intval($smtp_port);
    $mail->CharSet = 'UTF-8';
    
    // 发件人和收件人
    $mail->setFrom($email_sender ?: $smtp_username);
    
    // 添加收件人
    $recipients = explode(',', $email_recipients);
    foreach ($recipients as $recipient) {
        $recipient = trim($recipient);
        if (!empty($recipient)) {
            $mail->addAddress($recipient);
        }
    }
    
    // 邮件内容
    $mail->isHTML(true);
    $mail->Subject = '举报系统 - 测试邮件';
    $mail->Body = '
        <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 5px;">
            <h2 style="color: #333;">举报系统 - 测试邮件</h2>
            <p>您好，</p>
            <p>这是一封测试邮件，用于验证举报系统的邮件通知功能是否正常工作。</p>
            <p>如果您收到此邮件，说明邮件通知功能已配置成功。</p>
            <p style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #e0e0e0; color: #777; font-size: 12px;">
                此邮件由系统自动发送，请勿直接回复。<br>
                发送时间：' . date('Y-m-d H:i:s') . '
            </p>
        </div>
    ';
    $mail->AltBody = '举报系统 - 测试邮件

您好，

这是一封测试邮件，用于验证举报系统的邮件通知功能是否正常工作。
如果您收到此邮件，说明邮件通知功能已配置成功。

此邮件由系统自动发送，请勿直接回复。
发送时间：' . date('Y-m-d H:i:s');
    
    // 发送邮件
    $mail->send();
    
    // 返回成功信息
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'message' => '测试邮件发送成功！请检查收件箱。'
    ]);
    
} catch (Exception $e) {
    // 记录异常
    error_log('测试邮件发送异常: ' . $e->getMessage());
    
    // 返回错误信息
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '发送邮件时发生错误: ' . $e->getMessage()
    ]);
}