<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '未授权访问']);
    exit;
}

// 获取POST数据
$json = file_get_contents('php://input');
$settings = json_decode($json, true);

if (!$settings) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '无效的数据格式']);
    exit;
}

// 验证设置
if (isset($settings['admin_email']) && !empty($settings['admin_email']) && !filter_var($settings['admin_email'], FILTER_VALIDATE_EMAIL)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '无效的邮箱地址']);
    exit;
}

// 验证企业微信Webhook
if (isset($settings['enable_wechat_work']) && $settings['enable_wechat_work'] && 
    (!isset($settings['wechat_work_webhook']) || empty($settings['wechat_work_webhook']) || 
     !filter_var($settings['wechat_work_webhook'], FILTER_VALIDATE_URL))) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '无效的企业微信Webhook地址']);
    exit;
}

// 确保配置目录存在
$config_dir = '../config';
if (!file_exists($config_dir)) {
    mkdir($config_dir, 0755, true);
}

// 保存设置到文件
$config_file = '../config/notification_settings.php';
$config_content = "<?php\nreturn " . var_export($settings, true) . ";\n";

if (file_put_contents($config_file, $config_content)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => true]);
} else {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '无法写入配置文件']);
}