<?php
session_start();
require_once '../db_connect.php';

// 检查是否为POST请求
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // 获取表单数据
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // 验证输入
    if (empty($username) || empty($password)) {
        header("Location: login.php?error=请输入用户名和密码");
        exit;
    }
    
    // 查询数据库
    $stmt = $conn->prepare("SELECT id, username, password FROM admin_users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        
        // 直接比较明文密码
        if ($password === $user['password']) {
            // 登录成功，设置会话
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $user['id'];
            $_SESSION['admin_username'] = $user['username'];
            
            header("Location: index.php");
            exit;
        } else {
            header("Location: login.php?error=密码错误");
            exit;
        }
    } else {
        header("Location: login.php?error=用户名不存在");
        exit;
    }
    
    $stmt->close();
} else {
    // 如果不是POST请求，重定向到登录页面
    header("Location: login.php");
    exit;
}

$conn->close();
?>